VERSION 5.00
Begin VB.Form frmCh4 
   Caption         =   "Chapter 4 - Subclassing Example"
   ClientHeight    =   3336
   ClientLeft      =   48
   ClientTop       =   336
   ClientWidth     =   6960
   LinkTopic       =   "Form1"
   ScaleHeight     =   3336
   ScaleWidth      =   6960
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton cmdCreateWnd 
      Caption         =   "Create Wnd"
      Height          =   372
      Left            =   120
      TabIndex        =   3
      Top             =   120
      Width           =   1332
   End
   Begin VB.TextBox txtMessages 
      Height          =   3072
      Left            =   1560
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   2
      Top             =   120
      Width           =   5292
   End
   Begin VB.CommandButton cmdUnSubclass 
      Caption         =   "Un-Subclass"
      Height          =   372
      Left            =   120
      TabIndex        =   1
      Top             =   1080
      Width           =   1332
   End
   Begin VB.CommandButton cmdSubclass 
      Caption         =   "Subclass"
      Height          =   372
      Left            =   120
      TabIndex        =   0
      Top             =   600
      Width           =   1332
   End
End
Attribute VB_Name = "frmCh4"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdCreateWnd_Click()
    frmCh4.txtMessages.Text = frmCh4.txtMessages.Text & "Start window creation" & vbNewLine
    DoEvents
    
    'Create new form
    Dim CGSubForm As New frmGlobalSub
    CGSubForm.Caption = "Original Window"
    CGSubForm.Visible = True
    
    frmCh4.txtMessages.Text = frmCh4.txtMessages.Text & "Created new un-subclassed initial window - hwnd: " & Hex$(CGSubForm.hwnd) & vbNewLine
    DoEvents
        
    'Create subclassing object
    Set CSubClsApp = New CSubclass
    CSubClsApp.hwnd = CGSubForm.hwnd
    
    frmCh4.txtMessages.Text = frmCh4.txtMessages.Text & "Create subclassing obj & subclass - hwnd: " & Hex$(CGSubForm.hwnd) & vbNewLine
    DoEvents
    
    'Do not create a second instance, we will lose the original hwnd
    cmdCreateWnd.Enabled = False
End Sub

Private Sub cmdSubclass_Click()
    If cmdCreateWnd.Enabled = False Then
        frmCh4.txtMessages.Text = frmCh4.txtMessages.Text & "Set the global Subclass" & vbNewLine
        DoEvents
        
        Call CSubClsApp.EnableSubclass
        
        Set NewForm = New frmGlobalSub
        NewForm.Show
        
        frmCh4.txtMessages.Text = frmCh4.txtMessages.Text & "Created form to Subclass - hwnd: " & Hex$(NewForm.hwnd) & vbNewLine
        DoEvents
    Else
        MsgBox "Click on the 'Create Wnd' button to create a window to subclass."
    End If
End Sub

Private Sub cmdUnSubclass_Click()
    If cmdCreateWnd.Enabled = False Then
        frmCh4.txtMessages.Text = frmCh4.txtMessages.Text & "Unsubclass_Click" & vbNewLine
        DoEvents
    
        Call CSubClsApp.DisableSubclass
    Else
        MsgBox "Click on the 'Create Wnd' button to create a window to subclass."
    End If
End Sub

Private Sub Form_Load()
    frmCh4.txtMessages.Text = frmCh4.txtMessages.Text & "Form_Load - hwnd: " & Hex$(Me.hwnd) & vbNewLine
    DoEvents
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    frmCh4.txtMessages.Text = frmCh4.txtMessages.Text & "Form_QueryUnload - hwnd: " & Hex$(Me.hwnd) & vbNewLine
    DoEvents
    
    'Remove all child windows to prevent a GPF
    Dim I As Integer
    For I = Forms.Count - 1 To 0 Step -1
        If Forms(I).Caption <> "Chapter 4 - Subclassing Example" And Forms(I).Caption <> "Original Window" Then
            Unload Forms(I)
        End If
    Next I
    
    'Make sure class is destroyed here
    Set CSubClsApp = Nothing

    'Remove the original window to clean up
    For I = Forms.Count - 1 To 0 Step -1
        If Forms(I).Caption = "Original Window" Then
            Unload Forms(I)
        End If
    Next I
End Sub
